
#include "fp.h"
#include "matq.h"
#include "matcMath.hpp"
#include "matqMath.h"
#include "matfpMath.hpp"

using namespace std;

int main (int argc, char * const argv[])
{
    //matc        xc="1,0|2,0;2,0|5,0";
    //matc        xc="1,2|3,4|5,6;7,8|9,10|11,12;13,14|15,16|17,18";
    //matc        xc="1|0|0;0|2|4;0|4|8";
    //matc        xc="2|0|0;0|3|4;0|4|9";
    //matq        x="2,0,0,0;1,2,0,0;0,1,3,0;0,0,1,3";
    //matc        xc=".8|.3;.2|.7";
    //matc        x="1|2;2|4";
    //matfp        x="1,2,3;4,5,6;7,8,9";
    //matc        xc="3|0|0;-3|4|9;0|0|3"; // has free variables
    //matc        xc="2|0|0|0;1|2|0|0;0|1|3|0;0|0|1|3";
    //matq        x="1/3,2;-1,2/3";
    //matq        x="0,0;0,0";
    //matq        x="1,0;0,0";
    //matq        x="1,0;0,1";
    //matq        x="1,0;1,0";
    //matq        x="0,0,0;0,0,0;0,0,0";
    //matq        x="1,2;3,4";
    matc        x="1|2;2|4";
    matc        eigenvectors, eigenvalues;
    long        myDecPrec=16;
    fp          zeroSet=1e-16;
    long        i, j, k, kk;
    long        *algMultiplicity, *geoMultiplicity;
    
    setDecPrec(16);
    matcEigenvectors(eigenvectors, eigenvalues, algMultiplicity, geoMultiplicity, x, myDecPrec, zeroSet);
    for(k=0;k<eigenvalues.nr;++k)
    {
        cout << "eigenvalue = " << eigenvalues.array[k][0] << endl;
        cout << "algebraic multiplicity = " << algMultiplicity[k] << endl;
        cout << "geometric multiplicity = " << geoMultiplicity[k] << endl;
        cout << "eigenvector(s) = " << endl;
        for(j=0;j<geoMultiplicity[k];++j)
        {
            for(i=0;i<x.nr;++i)
            {
                if(i<x.nr-1)
                    cout << eigenvectors.array[i][kk] << endl;
                else
                    cout << eigenvectors.array[i][kk] << endl << endl;
            }
            kk++;
        }
    }
    return 0;
}
/*
 matc        x="1|2;2|4";
 eigenvalue = (5, 0)
 algebraic multiplicity = 1
 geometric multiplicity = 1
 eigenvector(s) =
 (1, 0)
 (2, 0)
 
 eigenvalue = (0, 0)
 algebraic multiplicity = 1
 geometric multiplicity = 1
 eigenvector(s) =
 (1, 0)
 (-0.5, 0)
 */
